/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.progressivebosses.module.dragon.feature;

import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.utils.LogHelper;
import insane96mcp.insanelib.utils.RandomHelper;
import insane96mcp.progressivebosses.module.dragon.phase.CrystalRespawnPhase;
import insane96mcp.progressivebosses.setup.Config;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.PaneBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.boss.dragon.EnderDragonEntity;
import net.minecraft.entity.boss.dragon.phase.IPhase;
import net.minecraft.entity.boss.dragon.phase.PhaseType;
import net.minecraft.entity.item.EnderCrystalEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.Explosion;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.EndPodiumFeature;
import net.minecraft.world.gen.feature.EndSpikeFeature;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;

@Label(name="Crystals", description="Makes more Crystal spawn and with more cages.")
public class CrystalFeature
extends Feature {
    private final ForgeConfigSpec.ConfigValue<Integer> moreCagesAtDifficultyConfig;
    private final ForgeConfigSpec.ConfigValue<Integer> maxBonusCagesConfig;
    private final ForgeConfigSpec.ConfigValue<Integer> moreCrystalsAtDifficultyConfig;
    private final ForgeConfigSpec.ConfigValue<Integer> maxMoreCrystalsConfig;
    private final ForgeConfigSpec.ConfigValue<Boolean> enableCrystalRespawnConfig;
    private final ForgeConfigSpec.ConfigValue<Double> crystalRespawnMultiplierConfig;
    private final ForgeConfigSpec.ConfigValue<Double> crystalRespawnInsideTowerChanceConfig;
    private final ForgeConfigSpec.ConfigValue<Boolean> explosionImmuneConfig;
    public int moreCagesAtDifficulty = 2;
    public int maxBonusCages = 4;
    public int moreCrystalsAtDifficulty = 8;
    public int maxMoreCrystals = 5;
    public boolean enableCrystalRespawn = true;
    public double crystalRespawnMultiplier = 0.6;
    public double crystalRespawnInsideTowerChance = 0.005;
    public boolean explosionImmune = true;
    private static final List<PhaseType<? extends IPhase>> VALID_CRYSTAL_RESPAWN_PHASES = Arrays.asList(PhaseType.field_188747_g, PhaseType.field_188748_h, PhaseType.field_188746_f, PhaseType.field_188741_a, PhaseType.field_188745_e);
    private static final ResourceLocation ENDERGETIC_CRYSTAL_HOLDER_RL = new ResourceLocation("endergetic:crystal_holder");

    public CrystalFeature(Module module) {
        super(Config.builder, module);
        this.pushConfig(Config.builder);
        this.moreCagesAtDifficultyConfig = Config.builder.comment("At this difficulty cages will start to appear around other crystals too. -1 will disable this feature.").defineInRange("More Cages at Difficulty", this.moreCagesAtDifficulty, -1, Integer.MAX_VALUE);
        this.maxBonusCagesConfig = Config.builder.comment("Max number of bonus cages that can spawn around the crystals.").defineInRange("Max Bonus Cages", this.maxBonusCages, 0, 8);
        this.moreCrystalsAtDifficultyConfig = Config.builder.comment("At this difficulty more crystals will start to appear inside obsidian towers. -1 will disable this feature.").defineInRange("More Crystals at Difficulty", this.moreCrystalsAtDifficulty, -1, Integer.MAX_VALUE);
        this.maxMoreCrystalsConfig = Config.builder.comment("Max number of bonus crystals that can spawn inside the towers.").defineInRange("Max Bonus Crystals", this.maxMoreCrystals, 0, 10);
        this.enableCrystalRespawnConfig = Config.builder.comment("Everytime the dragon is hit (when below 20% of health) there's a chance to to trigger a Crystal respawn Phase. The phase can only happen once. The chance is 0% when health >= 20% and 100% when health <= 5%.").define("Enable crystal respawn", this.enableCrystalRespawn);
        this.crystalRespawnMultiplierConfig = Config.builder.comment("Difficulty multiplied by this number will output how many tries will the dragon take to respawn crystals. Tries are capped between 1 and 100.").defineInRange("Crystal Respawn Multiplier", this.crystalRespawnMultiplier, 0.0, 100.0);
        this.crystalRespawnInsideTowerChanceConfig = Config.builder.comment("When respawning Crystals, chance for the crystal to be spawned inside a Tower instead of on top").defineInRange("Crystal Respawn Inside Tower Chance", this.crystalRespawnInsideTowerChance, 0.0, 1.0);
        this.explosionImmuneConfig = Config.builder.comment("Crystals can no longer be destroyed by other explosions.").define("Explosion Immune", this.explosionImmune);
        Config.builder.pop();
    }

    public void loadConfig() {
        super.loadConfig();
        this.moreCagesAtDifficulty = (Integer)this.moreCagesAtDifficultyConfig.get();
        this.maxBonusCages = (Integer)this.maxBonusCagesConfig.get();
        this.moreCrystalsAtDifficulty = (Integer)this.moreCrystalsAtDifficultyConfig.get();
        this.maxMoreCrystals = (Integer)this.maxMoreCrystalsConfig.get();
        this.enableCrystalRespawn = (Boolean)this.enableCrystalRespawnConfig.get();
        this.crystalRespawnMultiplier = (Double)this.crystalRespawnMultiplierConfig.get();
        this.crystalRespawnInsideTowerChance = (Double)this.crystalRespawnInsideTowerChanceConfig.get();
        this.explosionImmune = (Boolean)this.explosionImmuneConfig.get();
    }

    @SubscribeEvent
    public void onDragonDamage(LivingDamageEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        if (!(event.getEntity() instanceof EnderDragonEntity)) {
            return;
        }
        if (!this.enableCrystalRespawn) {
            return;
        }
        EnderDragonEntity dragon = (EnderDragonEntity)event.getEntity();
        CompoundNBT dragonTags = dragon.getPersistentData();
        float difficulty = dragonTags.func_74760_g("progressivebosses:difficulty");
        if (dragonTags.func_74767_n("progressivebosses:crystal_respawn")) {
            return;
        }
        if (!VALID_CRYSTAL_RESPAWN_PHASES.contains(dragon.func_184670_cT().func_188756_a().func_188652_i())) {
            return;
        }
        double healthRatio = dragon.func_110143_aJ() / dragon.func_110138_aP();
        if (healthRatio >= 0.2) {
            return;
        }
        double chance = (0.15 - (healthRatio - 0.05)) / 0.15;
        if ((double)dragon.func_70681_au().nextFloat() < chance) {
            return;
        }
        dragon.func_184670_cT().func_188758_a(CrystalRespawnPhase.getPhaseType());
        CrystalRespawnPhase phase = (CrystalRespawnPhase)dragon.func_184670_cT().func_188756_a();
        ArrayList spikes = new ArrayList(EndSpikeFeature.func_236356_a_((ISeedReader)((ServerWorld)dragon.field_70170_p)));
        int maxTries = (int)MathHelper.func_151237_a((double)((double)difficulty * this.crystalRespawnMultiplier), (double)1.0, (double)100.0);
        for (int i = 0; i < maxTries; ++i) {
            EndSpikeFeature.EndSpike targetSpike = (EndSpikeFeature.EndSpike)spikes.get(RandomHelper.getInt((Random)dragon.func_70681_au(), (int)0, (int)spikes.size()));
            phase.addCrystalRespawn(targetSpike);
        }
        dragonTags.func_74757_a("progressivebosses:crystal_respawn", true);
    }

    @SubscribeEvent
    public void onSpawn(EntityJoinWorldEvent event) {
        if (event.getWorld().field_72995_K) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        if (!(event.getEntity() instanceof EnderDragonEntity)) {
            return;
        }
        EnderDragonEntity dragon = (EnderDragonEntity)event.getEntity();
        CompoundNBT dragonTags = dragon.getPersistentData();
        float difficulty = dragonTags.func_74760_g("progressivebosses:difficulty");
        this.crystalCages(dragon, difficulty);
        this.moreCrystals(dragon, difficulty);
    }

    private void crystalCages(EnderDragonEntity dragon, float difficulty) {
        if (this.moreCagesAtDifficulty == -1 || this.maxBonusCages == 0) {
            return;
        }
        if (difficulty < (float)this.moreCagesAtDifficulty) {
            return;
        }
        CompoundNBT dragonTags = dragon.getPersistentData();
        if (dragonTags.func_74764_b("progressivebosses:crystal_cages")) {
            return;
        }
        dragonTags.func_74757_a("progressivebosses:crystal_cages", true);
        ArrayList<EnderCrystalEntity> crystals = new ArrayList<EnderCrystalEntity>();
        for (EndSpikeFeature.EndSpike endspikefeature$endspike : EndSpikeFeature.func_236356_a_((ISeedReader)((ServerWorld)dragon.field_70170_p))) {
            crystals.addAll(dragon.field_70170_p.func_217357_a(EnderCrystalEntity.class, endspikefeature$endspike.func_186153_f()));
        }
        crystals.removeIf(c -> c.field_70170_p.func_180495_p(c.func_233580_cy_().func_177981_b(2)).func_177230_c() == Blocks.field_150411_aY);
        Collections.shuffle(crystals);
        int crystalsInvolved = Math.round(difficulty - (float)this.moreCagesAtDifficulty + 1.0f);
        int cagesGenerated = 0;
        for (EnderCrystalEntity crystal : crystals) {
            CrystalFeature.generateCage(crystal.field_70170_p, crystal.func_233580_cy_());
            if (++cagesGenerated != crystalsInvolved && cagesGenerated != this.maxBonusCages) continue;
            break;
        }
    }

    private void moreCrystals(EnderDragonEntity dragon, float difficulty) {
        if (this.moreCrystalsAtDifficulty == -1 || this.maxMoreCrystals == 0) {
            return;
        }
        if (difficulty < (float)this.moreCrystalsAtDifficulty) {
            return;
        }
        CompoundNBT dragonTags = dragon.getPersistentData();
        if (dragonTags.func_74764_b("progressivebosses:more_crystals")) {
            return;
        }
        dragonTags.func_74757_a("progressivebosses:more_crystals", true);
        ArrayList crystals = new ArrayList();
        for (EndSpikeFeature.EndSpike endspikefeature$endspike : EndSpikeFeature.func_236356_a_((ISeedReader)((ServerWorld)dragon.field_70170_p))) {
            crystals.addAll(dragon.field_70170_p.func_217357_a(EnderCrystalEntity.class, endspikefeature$endspike.func_186153_f()));
        }
        Collections.shuffle(crystals);
        int crystalsInvolved = Math.round(difficulty - (float)this.moreCrystalsAtDifficulty + 1.0f);
        int crystalSpawned = 0;
        for (EnderCrystalEntity crystal : crystals) {
            CrystalFeature.generateCrystalInTower(dragon.field_70170_p, crystal.func_226277_ct_(), crystal.func_226278_cu_(), crystal.func_226281_cx_());
            if (++crystalSpawned != crystalsInvolved && crystalSpawned != this.maxMoreCrystals) continue;
            break;
        }
    }

    public boolean onDamageFromExplosion(EnderCrystalEntity enderCrystalEntity, DamageSource source) {
        if (!this.isEnabled()) {
            return false;
        }
        if (!this.explosionImmune) {
            return false;
        }
        return source.func_94541_c();
    }

    public static EnderCrystalEntity generateCrystalInTower(World world, double x, double y, double z) {
        Vector3d centerPodium = Vector3d.func_237492_c_((Vector3i)world.func_205770_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, EndPodiumFeature.field_186139_a));
        int spawnY = (int)(y - (double)RandomHelper.getInt((Random)world.func_201674_k(), (int)12, (int)24));
        if ((double)spawnY < centerPodium.func_82617_b()) {
            spawnY = (int)centerPodium.func_82617_b();
        }
        BlockPos crystalPos = new BlockPos(x, (double)spawnY, z);
        Stream blocks = BlockPos.func_218281_b((BlockPos)crystalPos.func_177982_a(-1, -1, -1), (BlockPos)crystalPos.func_177982_a(1, 1, 1));
        blocks.forEach(pos -> world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P()));
        BlockState baseBlockState = Blocks.field_150357_h.func_176223_P();
        if (ModList.get().isLoaded("endergetic")) {
            if (ForgeRegistries.BLOCKS.containsKey(ENDERGETIC_CRYSTAL_HOLDER_RL)) {
                baseBlockState = ((Block)ForgeRegistries.BLOCKS.getValue(ENDERGETIC_CRYSTAL_HOLDER_RL)).func_176223_P();
            } else {
                LogHelper.warn((String)"The Endergetic Expansion is loaded but the %s block was not registered", (Object[])new Object[]{ENDERGETIC_CRYSTAL_HOLDER_RL});
            }
        }
        world.func_175656_a(crystalPos.func_177982_a(0, -1, 0), baseBlockState);
        world.func_217385_a(null, (double)((float)crystalPos.func_177958_n() + 0.5f), (double)crystalPos.func_177956_o(), (double)crystalPos.func_177952_p() + 0.5, 5.0f, Explosion.Mode.DESTROY);
        EnderCrystalEntity crystal = new EnderCrystalEntity(world, (double)crystalPos.func_177958_n() + 0.5, (double)crystalPos.func_177956_o(), (double)crystalPos.func_177952_p() + 0.5);
        world.func_217376_c((Entity)crystal);
        return crystal;
    }

    public static void generateCage(World world, BlockPos pos) {
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        for (int k = -2; k <= 2; ++k) {
            for (int l = -2; l <= 2; ++l) {
                for (int i1 = 0; i1 <= 3; ++i1) {
                    boolean flag2;
                    boolean flag = MathHelper.func_76130_a((int)k) == 2;
                    boolean flag1 = MathHelper.func_76130_a((int)l) == 2;
                    boolean bl = flag2 = i1 == 3;
                    if (!flag && !flag1 && !flag2) continue;
                    boolean flag3 = k == -2 || k == 2 || flag2;
                    boolean flag4 = l == -2 || l == 2 || flag2;
                    BlockState blockstate = (BlockState)((BlockState)((BlockState)((BlockState)Blocks.field_150411_aY.func_176223_P().func_206870_a((Property)PaneBlock.field_196409_a, (Comparable)Boolean.valueOf(flag3 && l != -2))).func_206870_a((Property)PaneBlock.field_196413_c, (Comparable)Boolean.valueOf(flag3 && l != 2))).func_206870_a((Property)PaneBlock.field_196414_y, (Comparable)Boolean.valueOf(flag4 && k != -2))).func_206870_a((Property)PaneBlock.field_196411_b, (Comparable)Boolean.valueOf(flag4 && k != 2));
                    world.func_175656_a((BlockPos)blockpos$mutable.func_181079_c(pos.func_177958_n() + k, pos.func_177956_o() - 1 + i1, pos.func_177952_p() + l), blockstate);
                }
            }
        }
    }
}

